// Service Purchase Module
class ServicePurchase {
    constructor() {
        this.services = {
            'ai-strategy-sessions.html': { id: 1, name: 'AI Strategy Sessions', price: 199.99 },
            'ai-tech-stack-review.html': { id: 2, name: 'AI Tech Stack Review', price: 249.99 },
            'workflow-automation.html': { id: 3, name: 'Workflow Automation Discovery', price: 179.99 },
            'ai-growth-plans.html': { id: 4, name: 'AI Growth Plans', price: 299.99 },
            'ai-audit.html': { id: 5, name: 'AI Audit', price: 149.99 },
            'ai-shopify-builds.html': { id: 6, name: 'AI Shopify Store Build', price: 799.99 },
            'ai-woocommerce-builds.html': { id: 7, name: 'AI WooCommerce Build', price: 749.99 },
            'custom-gpt-chatbots.html': { id: 8, name: 'Custom GPT Chatbot', price: 599.99 },
            'ai-email-sms.html': { id: 9, name: 'AI Email & SMS Marketing', price: 649.99 },
            'sales-prediction-models.html': { id: 10, name: 'Sales Prediction Models', price: 899.99 },
            'customer-segmentation-ai.html': { id: 11, name: 'Customer Segmentation AI', price: 699.99 },
            'automated-support.html': { id: 12, name: 'Automated Support System', price: 749.99 },
            'prompt-writing-pack.html': { id: 13, name: 'Prompt Writing Pack', price: 99.99 },
            'auto-content-engine.html': { id: 14, name: 'Auto Content Engine', price: 299.99 },
            'ad-creative-package.html': { id: 15, name: 'Ad Creative Package', price: 149.99 },
            'ai-assistant-setup.html': { id: 16, name: 'AI Assistant Setup', price: 199.99 },
            'analytics-booster.html': { id: 17, name: 'Analytics Booster', price: 249.99 }
        };
        
        this.currentService = this.getCurrentService();
        this.init();
    }

    getCurrentService() {
        const currentPage = window.location.pathname.split('/').pop();
        return this.services[currentPage] || null;
    }

    init() {
        if (!this.currentService) return;
        
        this.injectPurchaseSection();
        this.attachEventListeners();
    }

    injectPurchaseSection() {
        // Find the hero section and add pricing after it
        const heroSection = document.querySelector('.hero-section');
        if (!heroSection) return;

        const purchaseSection = document.createElement('section');
        purchaseSection.className = 'service-purchase-section';
        purchaseSection.innerHTML = this.createPurchaseSectionHTML();

        // Insert after hero section
        heroSection.parentNode.insertBefore(purchaseSection, heroSection.nextSibling);
    }

    createPurchaseSectionHTML() {
        return `
            <div class="container">
                <div class="purchase-card">
                    <div class="pricing-info">
                        <div class="price-label">Starting from</div>
                        <div class="price-amount">$${this.currentService.price.toFixed(2)}</div>
                        <div class="price-note">Booking fee to secure consultation. Final pricing discussed during strategy session.</div>
                    </div>
                    <div class="purchase-actions">
                        <button class="add-to-cart-btn" onclick="servicePurchase.addToCart()">
                            <i class="fas fa-shopping-cart"></i>
                            Add to Cart
                        </button>
                        <button class="buy-now-btn" onclick="servicePurchase.buyNow()">
                            <i class="fas fa-bolt"></i>
                            Buy Now
                        </button>
                    </div>
                    <div class="purchase-features">
                        <div class="feature-item">
                            <i class="fas fa-check"></i>
                            <span>Expert consultation included</span>
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-check"></i>
                            <span>Custom strategy development</span>
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-check"></i>
                            <span>Implementation roadmap</span>
                        </div>
                    </div>
                </div>
            </div>
        `;
    }

    addToCart() {
        if (typeof cartManager === 'undefined') {
            console.error('Cart manager not loaded');
            return;
        }
        
        cartManager.addToCart(
            this.currentService.id,
            this.currentService.name,
            this.currentService.price
        );
    }

    buyNow() {
        if (typeof cartManager === 'undefined') {
            console.error('Cart manager not loaded');
            return;
        }
        
        cartManager.buyNow(
            this.currentService.id,
            this.currentService.name,
            this.currentService.price
        );
    }

    attachEventListeners() {
        // Update hero CTA to add to cart instead of contact
        const heroCTA = document.querySelector('.hero-actions .cta-button');
        if (heroCTA) {
            heroCTA.onclick = (e) => {
                e.preventDefault();
                this.addToCart();
                return false;
            };
        }
    }
}

// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    window.servicePurchase = new ServicePurchase();
});

// CSS Styles for purchase section
const purchaseStyles = `
<style>
.service-purchase-section {
    padding: 60px 0;
    background: linear-gradient(135deg, #0a0a0a 0%, #1a1a1a 100%);
    border-top: 1px solid rgba(0, 255, 136, 0.2);
    border-bottom: 1px solid rgba(0, 255, 136, 0.2);
}

.purchase-card {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 16px;
    padding: 2.5rem;
    backdrop-filter: blur(10px);
    display: grid;
    grid-template-columns: 1fr auto 1fr;
    gap: 2rem;
    align-items: center;
    max-width: 900px;
    margin: 0 auto;
    position: relative;
    overflow: hidden;
}

.purchase-card::before {
    content: '';
    position: absolute;
    top: -1px;
    left: -1px;
    right: -1px;
    bottom: -1px;
    background: linear-gradient(135deg, #00ff88, #00ccff);
    border-radius: 16px;
    z-index: -1;
    opacity: 0.1;
}

.pricing-info {
    text-align: left;
}

.price-label {
    font-size: 0.9rem;
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 8px;
    text-transform: uppercase;
    font-weight: 500;
    letter-spacing: 1px;
}

.price-amount {
    font-size: 3rem;
    font-weight: 700;
    color: #00ff88;
    margin-bottom: 12px;
    background: linear-gradient(135deg, #00ff88, #00ccff);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.price-note {
    font-size: 0.85rem;
    color: rgba(255, 255, 255, 0.6);
    line-height: 1.4;
}

.purchase-actions {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    min-width: 200px;
}

.add-to-cart-btn,
.buy-now-btn {
    padding: 14px 24px;
    border-radius: 8px;
    font-weight: 600;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.3s ease;
    border: none;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.add-to-cart-btn {
    background: transparent;
    color: #00ff88;
    border: 2px solid #00ff88;
}

.add-to-cart-btn:hover {
    background: #00ff88;
    color: #0a0a0a;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 255, 136, 0.3);
}

.buy-now-btn {
    background: linear-gradient(135deg, #00ff88, #00ccff);
    color: #0a0a0a;
}

.buy-now-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 255, 136, 0.4);
}

.purchase-features {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 12px;
    color: rgba(255, 255, 255, 0.8);
    font-size: 0.9rem;
}

.feature-item i {
    color: #00ff88;
    font-size: 0.8rem;
    width: 16px;
}

@media (max-width: 768px) {
    .purchase-card {
        grid-template-columns: 1fr;
        text-align: center;
        gap: 2rem;
        padding: 2rem;
    }
    
    .pricing-info {
        text-align: center;
    }
    
    .purchase-actions {
        order: -1;
    }
    
    .price-amount {
        font-size: 2.5rem;
    }
}

@media (max-width: 480px) {
    .purchase-actions {
        min-width: auto;
    }
    
    .add-to-cart-btn,
    .buy-now-btn {
        padding: 12px 20px;
        font-size: 0.9rem;
    }
    
    .price-amount {
        font-size: 2rem;
    }
}
</style>
`;

// Inject styles into document head
document.head.insertAdjacentHTML('beforeend', purchaseStyles);