// Component loader for shared header and footer
document.addEventListener('DOMContentLoaded', function() {
   // Initialize mobile menu functionality after header is loaded
function initializeMobileMenu() {
    const mobileToggle = document.querySelector('.mobile-menu-toggle');
    const navMenu = document.querySelector('.nav-menu');
    const mobileOverlay = document.querySelector('.mobile-menu-overlay');

    if (mobileToggle && navMenu && mobileOverlay) {
        // Toggle mobile menu
        mobileToggle.addEventListener('click', function() {
            const isActive = navMenu.classList.contains('mobile-active');

            if (isActive) {
                closeMobileMenu();
            } else {
                openMobileMenu();
            }
        });

        // Close menu when clicking overlay
        mobileOverlay.addEventListener('click', function() {
            closeMobileMenu();
        });

        // Handle dropdown toggles for mobile - prevent menu closure
        const dropdowns = document.querySelectorAll('.dropdown');
        dropdowns.forEach(dropdown => {
            const dropdownToggle = dropdown.querySelector('.nav-link');

            if (dropdownToggle && dropdownToggle.getAttribute('href') === '#') {
                dropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        e.preventDefault();
                        e.stopImmediatePropagation();

                        // Close all other dropdowns
                        dropdowns.forEach(otherDropdown => {
                            if (otherDropdown !== dropdown) {
                                otherDropdown.classList.remove('active');
                            }
                        });

                        // Toggle current dropdown
                        dropdown.classList.toggle('active');

                        // DO NOT close the mobile menu here - this is the key fix
                        return false;
                    }
                });
            }
        });

        // Handle service links within dropdowns (close menu)
        const serviceLinks = document.querySelectorAll('.dropdown .service-item, .dropdown .dropdown-item');
        serviceLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    closeMobileMenu();
                }
            });
        });

        // Handle main nav links that are not dropdown toggles (close menu)
        const mainNavLinks = document.querySelectorAll('.nav-menu > li > .nav-link:not([href="#"])');
        mainNavLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    closeMobileMenu();
                }
            });
        });

        // Close menu when window is resized to desktop
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                closeMobileMenu();
            }
        });

        // Close menu on escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && navMenu.classList.contains('mobile-active')) {
                closeMobileMenu();
            }
        });

        function openMobileMenu() {
            navMenu.classList.add('mobile-active');
            mobileToggle.classList.add('active');
            mobileOverlay.classList.add('active');
            document.body.style.overflow = 'hidden';
        }

        function closeMobileMenu() {
            navMenu.classList.remove('mobile-active');
            mobileToggle.classList.remove('active');
            mobileOverlay.classList.remove('active');
            document.body.style.overflow = '';
        }
    }
}

initializeMobileMenu();
});

